
<?php
require_once __DIR__ . '/inc/auth.php';
require_once __DIR__ . '/inc/db.php';
require_once __DIR__ . '/inc/helpers.php';
require_once __DIR__ . '/inc/csrf.php';
require_login();

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !verify_csrf($_POST['csrf'] ?? '')) {
    http_response_code(400);
    echo "Bad request";
    exit;
}

$user = current_user();
$from_id = intval($_POST['from_account'] ?? 0);
$to_acct = trim($_POST['to_account_number'] ?? '');
$amount = floatval($_POST['amount'] ?? 0);
$desc = trim($_POST['description'] ?? '');
if ($amount <= 0) { header('Location: dashboard.php'); exit; }

$pdo = db();
$pdo->beginTransaction();

// Make sure from_account belongs to current user
$stmt = $pdo->prepare("SELECT * FROM accounts WHERE id=? AND user_id=?");
$stmt->execute([$from_id, $user['id']]);
$from = $stmt->fetch();
if (!$from) { $pdo->rollBack(); die('Invalid from account'); }

// Find destination
$stmt = $pdo->prepare("SELECT * FROM accounts WHERE account_number=?");
$stmt->execute([$to_acct]);
$to = $stmt->fetch();
if (!$to) { $pdo->rollBack(); die('Destination account not found'); }

$amount_cents = intval(round($amount * 100));
if ($from['balance_cents'] < $amount_cents) { $pdo->rollBack(); die('Insufficient balance'); }

// Update balances
$pdo->prepare("UPDATE accounts SET balance_cents = balance_cents - ? WHERE id=?")->execute([$amount_cents, $from['id']]);
$pdo->prepare("UPDATE accounts SET balance_cents = balance_cents + ? WHERE id=?")->execute([$amount_cents, $to['id']]);

// Record transaction
$pdo->prepare("INSERT INTO transactions (from_account_id, to_account_id, amount_cents, description, created_at) VALUES (?,?,?,?,datetime('now'))")
    ->execute([$from['id'], $to['id'], $amount_cents, $desc]);

$pdo->commit();

header('Location: transactions.php');
exit;
