
<?php
require_once __DIR__ . '/inc/auth.php';
require_once __DIR__ . '/inc/db.php';
require_once __DIR__ . '/inc/helpers.php';
require_login();

$user = current_user();
// get accounts
$stmt = db()->prepare("SELECT id FROM accounts WHERE user_id=?");
$stmt->execute([$user['id']]);
$acct_ids = array_map(fn($r)=>$r['id'], $stmt->fetchAll());

if (empty($acct_ids)) { $acct_ids = [-1]; }
$in = implode(',', array_fill(0, count($acct_ids), '?'));

$sql = "SELECT t.*, a1.account_number AS from_acct, a2.account_number AS to_acct, a1.currency AS cur
        FROM transactions t
        LEFT JOIN accounts a1 ON a1.id = t.from_account_id
        LEFT JOIN accounts a2 ON a2.id = t.to_account_id
        WHERE (t.from_account_id IN ($in) OR t.to_account_id IN ($in))
        ORDER BY t.id DESC LIMIT 100";
$params = array_merge($acct_ids, $acct_ids);
$stmt = db()->prepare($sql);
$stmt->execute($params);
$tx = $stmt->fetchAll();
?>
<?php require_once __DIR__ . '/header.php'; ?>
<div class="card">
  <h2>Recent Transactions</h2>
  <table class="table">
    <tr><th>Date</th><th>From</th><th>To</th><th>Amount</th><th>Description</th></tr>
    <?php foreach ($tx as $t): ?>
      <tr>
        <td><?= e($t['created_at']) ?></td>
        <td><?= e($t['from_acct'] ?? '-') ?></td>
        <td><?= e($t['to_acct'] ?? '-') ?></td>
        <td><?= e(format_money($t['amount_cents'], $t['cur'] ?? 'NGN')) ?></td>
        <td><?= e($t['description']) ?></td>
      </tr>
    <?php endforeach; ?>
  </table>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>
