
<?php
require_once __DIR__ . '/inc/init_db.php';
require_once __DIR__ . '/inc/auth.php';
require_once __DIR__ . '/inc/helpers.php';
require_once __DIR__ . '/config.php';

// Ensure storage dir exists for SQLite
$storage = __DIR__ . '/storage';
if (!is_dir($storage)) { mkdir($storage, 0775, true); }

init_schema();

$pdo = db();
$exists = $pdo->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'] ?? 0;
$created = false;
$admin_email = ADMIN_EMAIL;
$admin_pass = ADMIN_PASSWORD;
$admin_user = 'admin';

if (intval($exists) === 0) {
    $hash = password_hash($admin_pass, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO users (email, username, password_hash, role, created_at) VALUES (?,?,?,?,datetime('now'))");
    $stmt->execute([$admin_email, $admin_user, $hash, 'admin']);
    $created = true;

    // seed a demo account for admin
    $admin_id = $pdo->lastInsertId();
    $acct = 'MXM' . str_pad(strval(random_int(0, 99999999)), 8, '0', STR_PAD_LEFT);
    $pdo->prepare("INSERT INTO accounts (user_id, account_number, currency, balance_cents, created_at) VALUES (?,?,?,?,datetime('now'))")
        ->execute([$admin_id, $acct, 'NGN', 5000000]);
}

?><!doctype html><html><head><meta charset="utf-8"><link rel="stylesheet" href="assets/style.css"><title>Setup</title></head>
<body><div class="container"><div class="card">
<h2>Setup</h2>
<?php if ($created): ?>
  <div class="notice">
    Admin created.<br>
    <strong>Email:</strong> <?= e($admin_email) ?><br>
    <strong>Password:</strong> <?= e($admin_pass) ?><br>
    <em>Login and change the password immediately.</em>
  </div>
<?php else: ?>
  <div class="notice">Database already initialized. No action taken.</div>
<?php endif; ?>
<p><a class="badge" href="login.php">Go to Login</a></p>
</div></div></body></html>
