
<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/inc/auth.php';
require_once __DIR__ . '/inc/csrf.php';
require_once __DIR__ . '/inc/helpers.php';

start_session_secure();

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf($_POST['csrf'] ?? '')) {
        $error = 'Invalid CSRF token.';
    } else {
        $email = trim($_POST['email'] ?? '');
        $password = $_POST['password'] ?? '';
        $stmt = db()->prepare("SELECT * FROM users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user'] = ['id'=>$user['id'],'email'=>$user['email'],'username'=>$user['username'],'role'=>$user['role']];
            header('Location: ' . APP_BASE_URL . '/dashboard.php');
            exit;
        } else {
            $error = 'Invalid credentials.';
        }
    }
}
?>
<?php require_once __DIR__ . '/header.php'; ?>
<div class="card" style="max-width:480px;margin:auto;">
  <h2>Sign in</h2>
  <?php if ($error): ?><div class="error"><?= e($error) ?></div><?php endif; ?>
  <form method="post">
    <?php csrf_field(); ?>
    <label>Email</label>
    <input name="email" type="email" required>
    <label>Password</label>
    <input name="password" type="password" required>
    <button type="submit">Login</button>
  </form>
  <p style="color:#9ca3af;margin-top:8px;">First time? Run <code>setup.php</code> to create an admin.</p>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>
