
<?php
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/db.php';

function start_session_secure() {
    if (session_status() === PHP_SESSION_NONE) {
        session_name(SESSION_NAME);
        session_set_cookie_params([
            'lifetime' => 0,
            'path' => '/',
            'httponly' => true,
            'secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on',
            'samesite' => 'Lax'
        ]);
        session_start();
    }
}

function current_user() {
    start_session_secure();
    return $_SESSION['user'] ?? null;
}

function require_login() {
    if (!current_user()) {
        header('Location: ' . APP_BASE_URL . '/login.php');
        exit;
    }
}

function require_admin() {
    require_login();
    if (($_SESSION['user']['role'] ?? '') !== 'admin') {
        http_response_code(403);
        echo "Forbidden";
        exit;
    }
}

function find_user_by_email($email) {
    $stmt = db()->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    return $stmt->fetch();
}

function find_user_by_username($username) {
    $stmt = db()->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    return $stmt->fetch();
}

function create_user($email, $username, $password, $role='user') {
    $hash = password_hash($password, PASSWORD_DEFAULT);
    $stmt = db()->prepare("INSERT INTO users (email, username, password_hash, role, created_at) VALUES (?,?,?,?,datetime('now'))");
    $stmt->execute([$email, $username, $hash, $role]);
    return db()->lastInsertId();
}

function create_account($user_id, $currency='NGN', $initial_cents=0) {
    $acct = 'MXM' . str_pad(strval(random_int(0, 99999999)), 8, '0', STR_PAD_LEFT);
    $stmt = db()->prepare("INSERT INTO accounts (user_id, account_number, currency, balance_cents, created_at) VALUES (?,?,?,?,datetime('now'))");
    $stmt->execute([$user_id, $acct, $currency, $initial_cents]);
    return $acct;
}
?>
