
<?php
require_once __DIR__ . '/inc/auth.php';
require_once __DIR__ . '/inc/helpers.php';
require_once __DIR__ . '/inc/db.php';
require_login();

$user = current_user();
$stmt = db()->prepare("SELECT * FROM accounts WHERE user_id = ?");
$stmt->execute([$user['id']]);
$accounts = $stmt->fetchAll();
?>
<?php require_once __DIR__ . '/header.php'; ?>
<div class="card">
  <h2>Hello, <?= e($user['username']) ?></h2>
  <p>Your accounts:</p>
  <table class="table">
    <tr><th>Account</th><th>Currency</th><th>Balance</th></tr>
    <?php foreach ($accounts as $a): ?>
    <tr>
      <td><?= e($a['account_number']) ?></td>
      <td><?= e($a['currency']) ?></td>
      <td><?= e(format_money($a['balance_cents'], $a['currency'])) ?></td>
    </tr>
    <?php endforeach; ?>
  </table>
</div>

<div class="card">
  <h3>Transfer (Internal)</h3>
  <form method="post" action="transfer.php">
    <?php require_once __DIR__ . '/inc/csrf.php'; csrf_field(); ?>
    <div class="row">
      <div>
        <label>From account</label>
        <select name="from_account" required>
          <?php foreach ($accounts as $a): ?>
            <option value="<?= e($a['id']) ?>"><?= e($a['account_number']) ?> (<?= e(format_money($a['balance_cents'],$a['currency'])) ?>)</option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>To account number</label>
        <input name="to_account_number" required>
      </div>
    </div>
    <div class="row">
      <div>
        <label>Amount</label>
        <input name="amount" type="number" min="0.01" step="0.01" required>
      </div>
      <div>
        <label>Description (optional)</label>
        <input name="description" maxlength="120">
      </div>
    </div>
    <button type="submit">Send</button>
  </form>
  <p class="notice">Demo-only: transfers are simulated inside this app.</p>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>
