
<?php
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/helpers.php';
require_admin();

$users = db()->query("SELECT id, email, username, role, created_at FROM users ORDER BY id DESC")->fetchAll();
?>
<?php require_once __DIR__ . '/../header.php'; ?>
<div class="card">
  <h2>Users</h2>
  <table class="table">
    <tr><th>ID</th><th>Email</th><th>Username</th><th>Role</th><th>Created</th></tr>
    <?php foreach ($users as $u): ?>
      <tr>
        <td><?= e($u['id']) ?></td>
        <td><?= e($u['email']) ?></td>
        <td><?= e($u['username']) ?></td>
        <td><span class="badge"><?= e($u['role']) ?></span></td>
        <td><?= e($u['created_at']) ?></td>
      </tr>
    <?php endforeach; ?>
  </table>
</div>
<?php require_once __DIR__ . '/../footer.php'; ?>
