
<?php
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/helpers.php';
require_admin();

$total_users = db()->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'];
$total_accounts = db()->query("SELECT COUNT(*) AS c FROM accounts")->fetch()['c'];
$total_tx = db()->query("SELECT COUNT(*) AS c FROM transactions")->fetch()['c'];

$recent = db()->query("SELECT t.*, a1.account_number AS from_acct, a2.account_number AS to_acct
                       FROM transactions t
                       LEFT JOIN accounts a1 ON a1.id=t.from_account_id
                       LEFT JOIN accounts a2 ON a2.id=t.to_account_id
                       ORDER BY t.id DESC LIMIT 10")->fetchAll();
?>
<?php require_once __DIR__ . '/../header.php'; ?>
<div class="card">
  <h2>Admin Dashboard</h2>
  <div class="row3">
    <div class="card"><strong>Users</strong><div class="badge"><?= e($total_users) ?></div></div>
    <div class="card"><strong>Accounts</strong><div class="badge"><?= e($total_accounts) ?></div></div>
    <div class="card"><strong>Transactions</strong><div class="badge"><?= e($total_tx) ?></div></div>
  </div>
  <p style="margin-top:12px;"><a class="badge" href="create_user.php">Create User</a> <a class="badge" href="users.php">Manage Users</a></p>
</div>

<div class="card">
  <h3>Recent Transactions</h3>
  <table class="table">
    <tr><th>Date</th><th>From</th><th>To</th><th>Amount (kobo)</th><th>Desc</th></tr>
    <?php foreach ($recent as $r): ?>
      <tr>
        <td><?= e($r['created_at']) ?></td>
        <td><?= e($r['from_acct'] ?? '-') ?></td>
        <td><?= e($r['to_acct'] ?? '-') ?></td>
        <td><?= e($r['amount_cents']) ?></td>
        <td><?= e($r['description']) ?></td>
      </tr>
    <?php endforeach; ?>
  </table>
</div>
<?php require_once __DIR__ . '/../footer.php'; ?>
