
<?php
require_once __DIR__ . '/../inc/auth.php';
require_once __DIR__ . '/../inc/db.php';
require_once __DIR__ . '/../inc/helpers.php';
require_once __DIR__ . '/../inc/csrf.php';
require_admin();

$msg = $err = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    if (!verify_csrf($_POST['csrf'] ?? '')) { $err = 'Invalid CSRF token.'; }
    else {
        $email = trim($_POST['email'] ?? '');
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';
        $currency = $_POST['currency'] ?? 'NGN';
        if (!$email || !$username || !$password) $err = 'All fields required.';
        else {
            try {
                $user_id = create_user($email, $username, $password, 'user');
                $acct = create_account($user_id, $currency, 0);
                $msg = "User created. Account: " . $acct;
            } catch (Throwable $e) {
                $err = 'Error: ' . $e->getMessage();
            }
        }
    }
}
?>
<?php require_once __DIR__ . '/../header.php'; ?>
<div class="card" style="max-width:640px;margin:auto;">
  <h2>Create User</h2>
  <?php if ($msg): ?><div class="notice"><?= e($msg) ?></div><?php endif; ?>
  <?php if ($err): ?><div class="error"><?= e($err) ?></div><?php endif; ?>
  <form method="post">
    <?php csrf_field(); ?>
    <label>Email</label><input name="email" type="email" required>
    <label>Username</label><input name="username" required>
    <label>Password</label><input name="password" type="password" required>
    <label>Currency</label>
    <select name="currency">
      <option>NGN</option><option>USD</option><option>EUR</option><option>GBP</option>
    </select>
    <button type="submit">Create</button>
  </form>
</div>
<?php require_once __DIR__ . '/../footer.php'; ?>
