
# MxM Online Banking (Demo)
**Educational demo only — not for real money or production use.**

This is a simple PHP app that simulates an online banking portal with user and admin areas.
- Users: sign in, view balance, send transfers between internal accounts, view transactions.
- Admin: create users, create accounts, view users and recent transactions.

## Tech
- PHP 8.0+ recommended
- SQLite (default) or MySQL via PDO
- Minimal CSS, no frameworks

## Quick Start (cPanel / Shared Hosting)
1. Upload `mxm-banking-php.zip` to your hosting and **Extract** it into `public_html/mxm` (or any folder).
2. Ensure the folder `storage/` is **writable** (permissions 775 or 755 typically).
3. Visit `https://yourdomain.com/mxm/setup.php` once to initialize the database and create the first admin.
4. Log in with the admin credentials printed by setup.
5. Go to **Admin → Create User** to add your first customer.

### Switching to MySQL (optional)
- Edit `config.php` and set `DB_DRIVER` to `mysql` and fill host/db/user/pass.
- Create a MySQL database and user in your hosting control panel.
- Re-run `setup.php` to initialize the schema in MySQL.

### Default SQLite Path
- `storage/mxm.sqlite` (created automatically on setup)

### Important
- Change the admin password right after first login.
- This app is a **demo**. It lacks many production features (2FA, email verification, audit logs, rate limiting, etc.).
- Do **not** handle real funds with this code.
